# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# If the emacs-el package has installed a pkgconfig file, use that to determine
# install locations and Emacs version at build time, otherwise set defaults.
%if %($(pkg-config emacs) ; echo $?)
%define emacs_version  21.0
%define emacs_lispdir  %{_datadir}/emacs/site-lisp
%define emacs_startdir %{_datadir}/emacs/site-lisp/site-start.d
%else
%define emacs_version  %{expand:%(pkg-config emacs --modversion)}
%define emacs_lispdir  %{expand:%(pkg-config emacs --variable sitepkglispdir)}
%define emacs_startdir %{expand:%(pkg-config emacs --variable sitestartdir)}
%endif

%define realname verilog-mode

Name:           emacs-%{realname}
Version:        531
Release:        alt1_13
Summary:        Verilog mode for Emacs

Group:          Engineering
License:        GPLv3+
URL:            http://www.veripool.org/wiki/verilog-mode/
Source0:        http://www.veripool.org/ftp/%{realname}-%{version}.el.gz

BuildRequires:  emacs26-common
BuildRequires:  emacs
Requires:       emacs >= %{emacs_version}
BuildArch:      noarch
Source44: import.info

%description
Verilog-mode.el is a free Verilog mode for Emacs
which provides context-sensitive highlighting,
auto indenting, and provides macro expansion
capabilities to greatly reduce Verilog coding time.

%prep
#setup -q
# /bin/tar: This does not look like a tar archive
rm -rf   %{_builddir}/%{name}-%{version}
mkdir -p %{_builddir}/%{name}-%{version}
cd       %{_builddir}/%{name}-%{version}
gunzip < %{SOURCE0} > %{realname}.el


%build

cd %{name}-%{version}
cat > %{realname}.el.site-start << EOF
;; Load verilog mode only when needed
(autoload 'verilog-mode "verilog-mode" "Verilog mode" t )
;; Any files that end in .v should be in verilog mode
(setq auto-mode-alist (cons '("\\.v\\'" . verilog-mode) auto-mode-alist))
;; Any files in verilog mode should have their keywords colorized
(add-hook 'verilog-mode-hook '(lambda () (font-lock-mode 1)))
EOF

%install

cd %{name}-%{version}

install -d %{buildroot}%{emacs_lispdir}
install -d %{buildroot}%{emacs_startdir}

emacs -batch -f batch-byte-compile %{realname}.el
install -pm 0644 %{realname}.el %{realname}.elc %{buildroot}%{emacs_lispdir}/
install -pm 0644 %{realname}.el.site-start %{buildroot}%{emacs_startdir}/%{realname}-init.el



%files
%{emacs_lispdir}/%{realname}.el
%{emacs_lispdir}/%{realname}.elc
%{emacs_startdir}/%{realname}-init.el


%changelog
