Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/cython /usr/bin/valgrind gcc-c++ perl(List/MoreUtils.pm) perl(Switch.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global gitdate 20151030

Name:           envytools
Version:        0.0
Release:        alt1_0.15.git%{gitdate}
Summary:        Tools for people envious of nvidia's blob driver
License:        MIT
URL:            https://github.com/envytools/envytools
# Generated by make-git-snapshot.sh
Source0:        envytools-%{gitdate}.tar.bz2
Source1:        make-git-snapshot.sh
ExclusiveArch: %{ix86} x86_64 %{arm} aarch64
BuildRequires:  gcc
BuildRequires:  ctest cmake flex bison
BuildRequires:  libpciaccess-devel libX11-devel libXext-devel libseccomp libseccomp-devel
BuildRequires:  libxml2-devel libvdpau-devel libdrm-devel python3-devel
Source44: import.info

%description
Envytools contains a number of tools used for debugging / development of
the nouveau driver:

envydis: Disassembler and assembler for various ISAs found on nvidia GPUs
nvbios:  Tools to decode the card description structures found in nvidia VBIOS
nva:     Tools to directly access the GPU registers
vstream: Tools to decode and encode raw video bitstreams


%package        hwdocs
Group: Other
Summary:        Nouveau hardware documentation
BuildArch:      noarch

%description    hwdocs
The %{name}-hwdocs package contains hardware documentation for video
hardware supported by the nouveau driver project.


%prep
%setup -q -n %{name}-%{gitdate}


%build
%{fedora_cmake} -DBUILD_SHARED_LIBS:BOOL=OFF .
%make_build


%install
%makeinstall_std
cp -p COPYING $RPM_BUILD_ROOT%{_docdir}/%{name}
# Remove the tools for rules-ng-ng XML register db manipulation
rm $RPM_BUILD_ROOT%{_bindir}/headergen
rm $RPM_BUILD_ROOT%{_bindir}/lookup
# Remove hwtest this really is for developers only
rm $RPM_BUILD_ROOT%{_bindir}/hwtest
# We do not want the libs (these are for internal use only)
rm $RPM_BUILD_ROOT%{_libdir}/*.a
rm -r $RPM_BUILD_ROOT%{_includedir}/%{name}
# Remove the python scripts used to generate the docs
rm $RPM_BUILD_ROOT%{_docdir}/%{name}/hwdocs/*.py


%files
%doc %dir %{_docdir}/%{name}
%{_docdir}/%{name}/COPYING
%doc %{_docdir}/%{name}/README*
%{_bindir}/de*
%{_bindir}/dumpstruct
%{_bindir}/envy*
%{_bindir}/evotiming
%{_bindir}/mmt_*
%{_bindir}/nv01*
%{_bindir}/nva*
%{_bindir}/nvbios
%{_bindir}/vdpow
%{_datadir}/rnndb

%files hwdocs
%doc %dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/hwdocs


%changelog
