# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Catalyst/Helper.pm) perl(LaTeX/Driver.pm) perl(Net/LDAP.pm) perl(Net/LDAP/Constant.pm) perl(Net/LDAP/Control/Paged.pm) perl(Pod/Usage.pm) perl(Template/Plugin/Filter.pm) perl(Test/More.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name Epoll
%define upstream_version 2.00

Name:       epoll
Version:    %upstream_version
Release:    alt1_4
License:    GPL+ or Artistic
Group:      Development/Perl
Summary:    A web voting application
Source:     %{upstream_name}-%{upstream_version}.tar.gz
Url:        http://forge.ipsl.jussieu.fr/epoll
BuildArch:  noarch
BuildRequires: perl(Catalyst.pm)
BuildRequires: perl(Catalyst/Plugin/ConfigLoader.pm)
BuildRequires: perl(Catalyst/Plugin/Static/Simple.pm)
BuildRequires: perl(Catalyst/Action/RenderView.pm)
BuildRequires: perl(Catalyst/Plugin/Session/State/Cookie.pm)
BuildRequires: perl(Catalyst/Plugin/Session/Store/DBI.pm)
BuildRequires: perl(Catalyst/View/TT.pm)
BuildRequires: perl(Catalyst/Plugin/Prototype.pm)
BuildRequires: perl(Catalyst/Plugin/I18N.pm)
BuildRequires: perl(YAML.pm)
BuildRequires: perl(Config/YAML.pm)
BuildRequires: perl(XML/Simple.pm)
BuildRequires: perl(Crypt/CBC.pm)
BuildRequires: perl(Crypt/DES_EDE3.pm)
BuildRequires: perl(Crypt/RSA.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(DBD/Pg.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Mail/Mailer.pm)
BuildRequires: perl(Locale/Maketext/Lexicon.pm)
BuildRequires: perl(Module/Install.pm)

Provides: Epoll = %version-%release
Obsoletes: Epoll < 2.0.0-3
Source44: import.info

%description
A web voting application

%prep
%setup -q -n %{upstream_name}-%{upstream_version} 

%build
sed -i '/^catalyst;/d' Makefile.PL
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
%makeinstall_std

mkdir -p %buildroot/etc
install -m 700 epoll.yml.example %buildroot%_sysconfdir/epoll.yml
mkdir -p %buildroot%_var/www/cgi-bin
install -m 755 script/epoll_cgi.pl %buildroot%_var/www/cgi-bin/epoll_cgi.pl
cp -a root/ %buildroot/%perl_vendor_privlib/Epoll/

%files
%doc Changes README
%doc sql/postgres.dump
%attr(0640,root,apache) %config(noreplace) %_sysconfdir/epoll.yml
%_bindir/*
%_var/www/cgi-bin/epoll_cgi.pl
%{_mandir}/man1/*
%perl_vendor_privlib/*


%changelog
