Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install /usr/bin/ps2pdf gcc-c++ libidn-devel librtmp-devel
# END SourceDeps(oneline)
BuildRequires:  /usr/bin/groff /usr/bin/grops /usr/bin/ps2pdf13 libpcre-devel
BuildRequires: chrpath
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _hardened_build 1
Name: ettercap
Version: 0.8.2
Release: alt1_14.20170306git60aca9
Summary: Network traffic sniffer/analyser, NCURSES interface version
License: GPLv2+
URL: http://ettercap.sourceforge.net
#Source0: http://downloads.sourceforge.net/ettercap/ettercap-%{version}.tar.gz
#Source0: https://github.com/Ettercap/ettercap/archive/v%{version}.tar.gz
Source0: ettercap-60aca9.tar.gz
Source1: ettercap.desktop
Source2: ettercap-README.fedora
# Permission from upstream to drop the silly modification restriction
Source3: ettercap_easter_egg_license.txt
#Patch4: ettercap-NG-0.7.3-mitm-loop.patch
#Patch5: ettercap-NG-0.7.3-selinux-fcntl.patch
# Remove the silly modification restriction
#Patch8: ettercap-NG-0.7.3-license-fix.patch
#Patch9: ettercap-0.7.4-CVE-2010-3843.patch
#Patch10: ettercap-0.7.5-dhcp-spoof.patch
#Patch11: ettercap-0.7.5.1-CVE-2013-0722.patch
#Patch12: ettercap-0.8.1-arbitrary-length.patch
#Patch13: ettercap-0.8.1-ignored-dn_expand-error.patch
#Patch14: ettercap-0.8.1-gg-dissector-arbitrary-length-heap-overflow.patch
Patch15: ettercap-0.8.1-radius-stack-overflow.patch
#Patch16: ettercap-0.8.1-cvs-ignore-end-checking.patch
#Patch17: ettercap-0.8.1-cvs-signed-pointer.patch
#Patch18: ettercap-0.8.1-cvs-ignore-base64-error-value.patch
Patch19: 1083d604930ebb9f350126b83802ecd2cbc17f90.patch


BuildRequires: desktop-file-utils
BuildRequires: ImageMagick-tools
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel libgtk+2-gir-devel
BuildRequires: libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires: libssl-devel
BuildRequires: libpcre-devel libpcrecpp-devel
BuildRequires: libtool
BuildRequires: bison
BuildRequires: flex
BuildRequires: ctest cmake
BuildRequires: libcurl-devel
BuildRequires: groff-base groff-extra groff-ps
#some requirements are available in fedora but not in stock epel
#build for epel requires libnet which is only available from rpmforge
%if 0%{?rhel}
BuildRequires: libnet
#epel 5
BuildRequires: libltdl7-devel
BuildRequires: libpcap-devel
%endif
%if 0%{?fedora}
BuildRequires: libpcap-devel
BuildRequires: libnet2-devel
BuildRequires: libltdl7-devel
%endif
Obsoletes: ettercap-plugins < 0.7.3-15
Provides: ettercap-plugins = %{version}-%{release}
Obsoletes: ettercap-common < 0.7.5
Provides: ettercap-common = %{version}-%{release}
Obsoletes: ettercap-gtk < 0.7.5
Provides: ettercap-gtk = %{version}-%{release}

Requires: polkit ethtool
Source44: import.info

%description
Ettercap is a suite for man in the middle attacks on LAN. It features
sniffing of live connections, content filtering on the fly and many other
interesting tricks. It supports active and passive dissection of many
protocols (even ciphered ones) and includes many feature for network and host
analysis. 


%prep
%setup -qn ettercap-60aca9

#%patch4 -p0
#%patch5 -p0
#%patch8 -p1 -b .license
#%patch9 -p0
#%patch10 -p0
#%patch11 -p1
#%patch12 -p1
#%patch13 -p1
#%patch14 -p1
%patch15 -p1
#%patch16 -p1
#%patch17 -p1
#%patch18 -p1
%patch19 -p1

rm -rf bundled_deps

%build
mkdir build
pushd build
%{fedora_cmake} ../ -DINSTALL_PREFIX=/usr -DMAN_INSTALLDIR=%{_mandir} -DINSTALL_LIBDIR=%{_libdir} -DENABLE_IPV6=yes -DPCRE_INCLUDE_DIR=/usr/include/pcre
make CFLAGS="$RPM_BUILD_FLAGS"

%install
mkdir -p  %{buildroot}%{_bindir}
pushd build
make install DESTDIR=%{buildroot}
make install man DESTDIR=%{buildroot}
#getting rid of libtool files potentially left behind when building plugins
rm -f %{buildroot}%{_libdir}/ettercap/*.la
mkdir -p %{buildroot}%{_docdir}
install -c -m 644 %{SOURCE2} %{buildroot}%{_docdir}
install -c -m 644 %{SOURCE3} %{buildroot}%{_docdir}
touch %{buildroot}%{_bindir}/ettercap

mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install \
  --dir %{buildroot}%{_datadir}/applications \
  %{SOURCE1}

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/32x32/apps
install -p -m 644 ../share/ettercap.png \
  %{buildroot}%{_datadir}/icons/hicolor/32x32/apps
rm -f ettercap*png
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done




%files
%doc LICENSE AUTHORS CHANGELOG THANKS TODO* README doc/
%{_bindir}/etter*
%config(noreplace) %{_sysconfdir}/ettercap/
%{_docdir}/ettercap-README.fedora
%{_docdir}/ettercap_easter_egg_license.txt
%{_mandir}/man5/etter*
%{_mandir}/man8/etter*
%{_datadir}/ettercap/
%{_libdir}/ettercap/
%{_libdir}/libettercap.so*
%{_datadir}/applications/ettercap.desktop
%{_datadir}/icons/hicolor/32x32/apps/ettercap.png
%{_datadir}/pixmaps/ettercap.svg
%{_datadir}/polkit-1/actions/org.pkexec.ettercap.policy
%{_datadir}/appdata/ettercap.appdata.xml

%changelog
