Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gsi-cert-utils
%global _name %(tr - _ <<< %{name})
Version:	10.11
Release:	alt1_1
Summary:	Grid Community Toolkit - Globus GSI Cert Utils Library

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-openssl-module-devel >= 3
BuildRequires:	globus-gsi-openssl-error-devel >= 2
BuildRequires:	libssl-devel
BuildRequires:	openssl
BuildRequires:	doxygen
BuildRequires:	rpm-build-perl
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - Globus GSI Cert Utils Library Programs
Requires:	openssl
BuildArch:	noarch

%package devel
Group: Development/Other
Summary:	Grid Community Toolkit - Globus GSI Cert Utils Library Development Files
Requires:	%{name} = %{version}-%{release}

%package doc
Group: Documentation
Summary:	Grid Community Toolkit - Globus GSI Cert Utils Library Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus GSI Cert Utils Library

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
Globus GSI Cert Utils Library Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Globus GSI Cert Utils Library Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
Globus GSI Cert Utils Library Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

export GLOBUS_VERSION=6.2
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
%make_build check



%files
%{_libdir}/libglobus_gsi_cert_utils.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files progs
%{_bindir}/grid-cert-info
%{_bindir}/grid-cert-request
%{_bindir}/grid-change-pass-phrase
%{_sbindir}/globus-update-certificate-dir
%{_sbindir}/grid-default-ca
%doc %{_mandir}/man1/grid-cert-info.1*
%doc %{_mandir}/man1/grid-cert-request.1*
%doc %{_mandir}/man1/grid-change-pass-phrase.1*
%doc %{_mandir}/man8/globus-update-certificate-dir.8*
%doc %{_mandir}/man8/grid-default-ca.8*
%doc --no-dereference GLOBUS_LICENSE

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_gsi_cert_utils.so
%{_libdir}/pkgconfig/%{name}.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
