Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname javadocofflinesearch
%global srcname JavadocOfflineSearch

Name:           javadocofflinesearch
Version:        2.2
Release:        alt1_15
Summary:        Tool for offline searching in your docs via browser
BuildArch:      noarch

License:        GPLv3+
URL:            https://github.com/judovana/%{srcname}
Source0:        https://github.com/judovana/%{srcname}/releases/tag/%{srcname}-2.2/%{srcname}-%{version}.tar.gz
# already fixed in upstream https://github.com/judovana/JavadocOfflineSearch/commit/853285f3105506b860c762f534e1a7c2733a2c61
Patch1:         javadocFixes.patch
# fixed license https://github.com/judovana/JavadocOfflineSearch/commit/7d0c410d9ef215499f4fa4fb67e9a105f0a95ba7
Patch2:         7d0c410d9ef215499f4fa4fb67e9a105f0a95ba7.diff
# updated to pdfbox 2.x since f28
Patch3:         pdfbox2.patch
Patch4:         longLucene.patch
Patch5:         753213ae509495a70855369b3991493ac5bdbcc2.patch
 
BuildRequires:  ant
BuildRequires:  java-devel
BuildRequires:  tagsoup
BuildRequires:  lucene-core
#BuildRequires:  lucene-analyzers-common hidden in
BuildRequires:  lucene-analysis
BuildRequires:  lucene-queries
BuildRequires:  lucene-queryparser
BuildRequires:  apache-commons-cli
BuildRequires:  pdfbox
#BuildRequires:  apache-commons-logging-api included in:
BuildRequires:  apache-commons-logging
BuildRequires:  fontbox

Requires:  jpackage-utils
Requires:  java-headless
Requires:  tagsoup
Requires:  lucene-core
#Requires:  lucene-analyzers-common hidden in
Requires:  lucene-analysis
Requires:  lucene-queries
Requires:  lucene-queryparser
Requires:  apache-commons-cli
Requires:  lucene-backward-codecs
Requires:  pdfbox
#Recommends:  apache-commons-logging-api included in:
Requires:  apache-commons-logging
Requires:  fontbox 
Source44: import.info

%description
The goal of this project was to make searching in your (java)docs as easy and
 comfortable as when you are browsing them online.

%package javadoc
Group: Other
Summary:        Javadocs for %{name}
Requires:       %{name} = %{version}-%{release}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q -n %{srcname}-%{srcname}-%{version}
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

find -print -name '*.class' -or -name '*.jar'  -delete


%build
ant

#pack manually
pushd  build/classes
jar -cvf ../../dist/%{name}.jar *
popd

%install
install -m0644  dist/%{name}.jar -D $RPM_BUILD_ROOT/%{_javadir}/%{name}.jar

mkdir -p $RPM_BUILD_ROOT/%{_javadocdir}
cp -r  dist/javadoc  $RPM_BUILD_ROOT/%{_javadocdir}/%{name}

mkdir -p $RPM_BUILD_ROOT/%{_bindir}

cat <<EOF > $RPM_BUILD_ROOT/%{_bindir}/%{name}
#!/bin/bash
. /usr/share/java-utils/java-functions

MAIN_CLASS=javadocofflinesearch.JavadocOfflineSearch

set_classpath "javadocofflinesearch"
set_classpath "tagsoup"
set_classpath "lucene-core"
set_classpath "lucene-analysis"
set_classpath "lucene-queries"
set_classpath "lucene-queryparser"
set_classpath "apache-commons-cli"
set_classpath "pdfbox"
set_classpath "apache-commons-logging"
set_classpath "fontbox"
set_classpath "lucene-backward-codecs"

EOF
# ${@} in cat EOF is susbtitued by nothing
echo 'run ${@}' >> $RPM_BUILD_ROOT/%{_bindir}/%{name}




%files
%{_javadir}/*
%doc --no-dereference LICENSE
%attr(755,root,root) %{_bindir}/%{name}


%files javadoc
%{_javadocdir}/%{name}
%doc --no-dereference LICENSE


%changelog
