# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           langtable
Version:        0.0.34
Release:        alt1_10
Summary:        Guess reasonable defaults for locale/language configuration
Group:          Development/Tools
# the translations in languages.xml and territories.xml are (mostly)
# imported from CLDR and are thus under the Unicode license, the
# short name for this license is "MIT", see:
# https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#Modern_Style_without_sublicense_.28Unicode.29
License:        GPLv3+
URL:            https://github.com/mike-fabian/langtable
Source0:        https://github.com/mike-fabian/langtable/releases/download/%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  pkgconfig(python3)

# Required purely to run simple expressions at build-time
BuildRequires:  perl
# Required for xmllint
BuildRequires:  xml-utils
Source44: import.info

%description
langtable is used to guess reasonable defaults for locale, keyboard layout,
territory, and language, if part of that information is already known. For
example, guess the territory and the keyboard layout if the language
is known or guess the language and keyboard layout if the territory is
already known.

%package -n python3-module-langtable
Summary:        Python module to query the langtable-data
Group:          Development/Python
License:        GPLv3+
Requires:       %{name} = %{version}-%{release}
Requires:       %{name}-data = %{version}-%{release}
%{?python_provide:%python_provide python3-%{name}}

%description -n python3-module-langtable
This package contains a Python module to query the data
from langtable-data.


%package data
Summary:        Data files for langtable
Group:          Development/Tools
License:        GPLv3+ and MIT
Requires:       %{name} >= %{version}-%{release}

%description data
This package contains the data files for langtable.

%prep
%setup -q

%build
perl -pi -e "s,_datadir = '(.*)',_datadir = '%{_datadir}/langtable'," langtable.py
%python3_build

%install
%python3_install --install-data=%{_datadir}/langtable
# the .xml files copied by the “python3 setup.py install” are identical
# to those copied in the “python2 setup.py install”,
# it does not hurt to gzip them again:
gzip --force --best $RPM_BUILD_ROOT/%{_datadir}/langtable/*.xml

%check
(cd $RPM_BUILD_DIR/%{name}-%{version}/data; LC_CTYPE=en_US.UTF-8 PYTHONPATH=.. %{__python3} ../test_cases.py; %{__python3} ../langtable.py)
xmllint --noout --relaxng $RPM_BUILD_ROOT/%{_datadir}/langtable/schemas/keyboards.rng $RPM_BUILD_ROOT/%{_datadir}/langtable/keyboards.xml.gz
xmllint --noout --relaxng $RPM_BUILD_ROOT/%{_datadir}/langtable/schemas/languages.rng $RPM_BUILD_ROOT/%{_datadir}/langtable/languages.xml.gz
xmllint --noout --relaxng $RPM_BUILD_ROOT/%{_datadir}/langtable/schemas/territories.rng $RPM_BUILD_ROOT/%{_datadir}/langtable/territories.xml.gz
xmllint --noout --relaxng $RPM_BUILD_ROOT/%{_datadir}/langtable/schemas/timezoneidparts.rng $RPM_BUILD_ROOT/%{_datadir}/langtable/timezoneidparts.xml.gz
xmllint --noout --relaxng $RPM_BUILD_ROOT/%{_datadir}/langtable/schemas/timezones.rng $RPM_BUILD_ROOT/%{_datadir}/langtable/timezones.xml.gz

%files
%doc --no-dereference COPYING
%doc README ChangeLog unicode-license.txt test_cases.py
%dir %{_datadir}/langtable/
%{_datadir}/langtable/schemas

%files -n python3-module-langtable
%{python3_sitelibdir_noarch}/*

%files data
%{_datadir}/langtable/*.xml.gz



%changelog
