%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/dot /usr/bin/gettext /usr/bin/svn boost-devel
# END SourceDeps(oneline)
BuildRequires: /proc
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libclaw
Version:        1.7.4
Release:        alt2_38
Summary:        C++ Library of various utility functions
License:        LGPLv2
URL:            http://libclaw.sourceforge.net/
Source0:        http://dl.sourceforge.net/project/%{name}/%{version}/%{name}-%{version}.tar.gz
Patch0:         libclaw-1.6.1-nostrip.patch
Patch1:         libclaw-1.7.4-libdir.patch
Patch2:         libclaw-1.7.4-gcc62.patch
# Make documentation the same on different arches
Patch3:         libclaw-1.7.4-noarch.patch
# Fix errors found by GCC 7 (and Clang)
Patch4:         libclaw-1.7.4-gcc7.patch
BuildRequires:  gcc-c++
BuildRequires:  libjpeg-devel
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  zlib-devel
BuildRequires:  ctest cmake
BuildRequires:  doxygen
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  boost-complete
Source44: import.info
Patch33: libclaw-1.7.4-alt-linkage.patch

%description
Claw (C++ Library Absolutely Wonderful) is a C++ library of various utility
functions. In doesn't have a particular objective but being useful to
anyone.


%package devel
Group: Development/Other
Summary:        Development files for Claw library
Requires:       %{name} = %{version}-%{release}
Requires:       ctest cmake
Requires:       boost-complete
Requires:       libpng17-tools

%description devel
This package contains files needed to develop and build software against
Claw (C++ Library Absolutely Wonderful).


%package doc
Group: Documentation
Summary:        Documentation for Claw library
BuildArch:      noarch

%description doc
This package contains documentation for Claw (C++ Library Absolutely
Wonderful).


%prep
%setup -q
%patch0 -p1 -b .nostrip
%patch1 -p1 -b .libdir
%patch2 -p1 -b .gcc62
%patch3 -p1 -b .noarch
%patch4 -p1 -b .gcc7
%patch33 -p1


%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build
find examples -type f |
while read F
do
        iconv -f iso8859-1 -t utf-8 $F |sed 's/\r//' >.utf8
        touch -r $F .utf8
        mv .utf8 $F
done


%install
%fedora_v2_cmake_install
%find_lang %{name}





%files -f %{name}.lang
%doc --no-dereference COPYING
%{_libdir}/*.so.*


%files devel
%{_bindir}/claw-config
%{_includedir}/claw
%{_libdir}/cmake/%{name}
%{_libdir}/*.so
%exclude %{_libdir}/*.a


%files doc
%doc --no-dereference COPYING
%doc %{_datadir}/doc/libclaw1
%doc examples


%changelog
