Group: Development/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: milia
Version: 1.0.0
Release: alt2_39
Summary: C++ cosmology library

License: GPLv3+
URL: http://guaix.fis.ucm.es/projects/milia/wiki
Source0: ftp://astrax.fis.ucm.es/pub/software/%{name}/%{name}-%{version}.tar.xz
Patch0: milia.cxx11.patch

BuildRequires: gcc-c++ libgsl-devel boost-complete cppunit-devel
Source44: import.info

%description
Milia is a C++ library created to compute cosmological distances and 
ages in the Friedmann-LemaA.tre-Robertson-Walker metric. 
The luminosity distance is 
computed using elliptical functions (Kantowski, Kao, Thomas 2000). 
The remaining distances are computed from the luminosity distance using 
Hogg 1999. The age is computed following Thomas & Kantowski 2000, using also 
elliptical functions.

%package devel
Group: Development/Other
Summary: Headers for developing programs that will use %{name}
Requires: boost-complete
Requires: %{name} = %{version}-%{release}
%description devel
These are the header files and libraries needed to develop a %{name} 
application.

%prep
%setup -q
%patch0 -p1

%build
%configure --enable-static=no --enable-shared=yes
%make_build

%check
make %{?_smp_mflags} check

%install
make %{?_smp_mflags} install DESTDIR=%{buildroot}



%files
%doc NEWS README
%doc --no-dereference COPYING
%{_libdir}/*so.*

%files devel
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_includedir}/*

%changelog
