Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		minicomputer
Version:	1.41
Release:	alt3_34
Summary:	Software Synthesizer
License:	GPLv3+
URL:		http://minicomputer.sourceforge.net/
Source0:	http://downloads.sourceforge.net/minicomputer/MinicomputerV%{version}.tar.gz
Source1:	%{name}.desktop
# DSO linking fix. Sent upstream by email.
Patch0:		%{name}-linking.patch
# GCC 4.7 fix
Patch1:		%{name}-gcc47.patch
# Build with Python 3
Patch2:		%{name}-build-python3.patch

BuildRequires:	gcc-c++
BuildRequires:	libalsa-devel
BuildRequires:	desktop-file-utils
BuildRequires:	libfltk-devel
BuildRequires:	libjack-devel
BuildRequires:	liblo-devel
BuildRequires:	/usr/bin/scons

Requires:	icon-theme-hicolor
Source44: import.info

%description
Minicomputer is a standalone Linux software synthesizer for creating 
experimental electronic sounds as its often used in but not limited to
Industrial music, IDM, EBM, Glitch, sound design and minimal electronic. It is
monophonic but can produce up to 8 different sounds at the same time. It uses
Jack as realtime audio infrastructure and can be controlled via Midi.

%prep
%setup -q -c -n MinicomputerV%{version}
%patch0 -p1 -b .linking
%patch1 -p1 -b .%{name}-gcc47.patch
%patch2 -p1 -b .%{name}-build-python3.patch

# Fix optflags
# SSE instruction set, which provides improved functionality, is only available in these archs:
%ifnarch %{ix86} x86_64 ia64
sed -i "s|\(^env.Append(CCFLAGS =\).*|\1 ['%{optflags}'.split() ])|" SConstruct
%else
sed -i "s|\(^env.Append(CCFLAGS =\).*|\1 ['%{optflags}'.split(),'-msse','-mfpmath=sse' ])|" SConstruct
%endif
sed -i "s|\(^guienv.Append(CPPFLAGS =\).*|\1 ['%{optflags}'.split() ])|" SConstruct

%build
scons %{?_smp_mflags}

%install
mkdir -p %{buildroot}%{_bindir}
install -pm 755 %{name}{,CPU} %{buildroot}%{_bindir}/

mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install				\
--dir=%{buildroot}%{_datadir}/applications	\
%{SOURCE1}

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/32x32/apps
install -pm 644 %{name}.xpm \
	%{buildroot}%{_datadir}/icons/hicolor/32x32/apps

%files
%doc CHANGES README minicomputerManual.pdf factoryPresets
%doc --no-dereference COPYING
%{_bindir}/%{name}*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/32x32/apps/%{name}.xpm

%changelog
