Group: Other
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       miniupnpd
Version:    2.3.4
Release:    alt1_3
Summary:    Daemon to offer UPnP-IGD and NAT-PMP support

License:    BSD
URL:        http://miniupnp.free.fr/
Source0:    http://miniupnp.free.fr/files/%{name}-%{version}.tar.gz
Source1:    miniupnpd.service
Patch0:     miniupnpd-init-selinux.patch

BuildRequires:  gcc
%{?systemd_requires}
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
%if 0%{?with_iptables}
BuildRequires:  libiptables-devel
%else
Buildrequires:  libmnl-devel
Buildrequires:  libnftnl-devel
%endif
BuildRequires:  libuuid-devel
BuildRequires:  libproc2 procps
Source44: import.info


%description
The MiniUPnP daemon is a UPnP Internet Gateway Device.

UPnP and NAT-PMP are used to improve internet connectivity for devices behind
a NAT router. Any peer to peer network application such as games, IM, etc. can
benefit from a NAT router supporting UPnP and/or NAT-PMP.


%prep
%setup -q
%patch0 -p1



%build
export CFLAGS="%{optflags}"
export 
./configure \
 --ipv6 \
 --igd2 \
%if 0%{?with_iptables}
 --firewall=iptables
%else
 --firewall=nftables
%endif
sed -i 's/ OS_NAME.*$/ OS_NAME "Fedora"/' config.h
sed -i 's/ OS_VERSION.*$/ OS_VERSION "%{fedora}\/%%s"/' config.h
sed -i 's/ OS_URL.*$/ OS_URL "https:\/\/getfedora.org"/' config.h
sed -i 's/^CFLAGS.*$//g' Makefile
sed -i 's/^LDFLAGS.*$//g' Makefile
sed -i 's/        policy drop;/        policy accept;/' netfilter_nft/scripts/nft_init.sh
%make_build


%install
export STRIP="/bin/true"
%makeinstall_std

install -Dpm 644 %{SOURCE1} %{buildroot}%{_unitdir}/%{name}.service

#Do not ship SysVinit script
rm -f %{buildroot}/etc/init.d/%{name}


%post
%post_service %{name}


%preun
%preun_service %{name}


%files
%doc --no-dereference LICENSE
%doc INSTALL README
%{_sbindir}/%{name}
%dir %{_sysconfdir}/%{name}
%{_sysconfdir}/%{name}/*.sh
%config(noreplace) %{_sysconfdir}/%{name}/miniupnpd.conf
%{_mandir}/man8/%{name}.8*
%{_unitdir}/%{name}.service


%changelog
