Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename jschardet
%global enable_tests 0
# tests disabled until dev dependencies are available

Name:		nodejs-jschardet
Version:	1.4.2
Release:	alt1_8
Summary:	Character encoding auto-detection in JavaScript (port of python's chardet)

License:	LGPLv2+
# License is at the top of src/init.js, but we'll split it out into a separate file in prep
URL:		https://github.com/aadsm/jschardet.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(qunit)
%endif
Source44: import.info

%description
Character encoding auto-detection in JavaScript (port of python's chardet)


%prep
%setup -q -n package
# License is at the top of src/init.js, but we'll split it out into a separate file now
head -n 30 src/init.js > LICENSE-LGPL.txt

# Remove bundled version of qunit
rm -rf tests/qunit/

# Add shebang
sed -i '1s;^;#!/usr/bin/node\n;' *.js

# remove executable bits from files that don't need them
chmod -x README.md package.json src/*.js

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js src/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%if 0%{?enable_tests}
%{_bindir}/qunit -c jschardet:src/init.js -t tests/jschardet.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-LGPL.txt
%{nodejs_sitelib}/%{packagename}



%changelog
