Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename loud-rejection
%global enable_tests 0
# tests disabled until npm(ava) is packaged in Fedora

Name:		nodejs-loud-rejection
Version:	1.6.0
Release:	alt1_8
Summary:	Make unhandled promise rejections fail loudly instead of the default silent fail

License:	MIT
URL:		https://github.com/sindresorhus/loud-rejection
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/loud-rejection/v%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(currently-unhandled)
BuildRequires:	npm(signal-exit)
%if 0%{?enable_tests}
BuildRequires:	npm(ava)
%endif
Source44: import.info

%description
Make unhandled promise rejections fail loudly instead of the default silent fail


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js api.js register.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%__nodejs test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}



%changelog
