Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-promise
Version:    8.0.1
Release:    alt1_6
Summary:    Bare bones Promises/A+ implementation for Node.js
License:    MIT
URL:        https://github.com/then/promise
Source0:    http://registry.npmjs.org/promise/-/promise-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  node-mocha
BuildRequires:  npm(asap)
BuildRequires:  npm(better-assert)
BuildRequires:  npm(promises-aplus-tests)
%endif
Source44: import.info

%description
This is a bare bones Promises/A+ implementation for Node.js. It is designed
to get the basics spot on correct, so that you can build extended promise
implementations on top of it.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%nodejs_fixdep asap "^2.0.3"

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/promise
cp -pr package.json *.js lib/ domains/ setimmediate/ \
    %{buildroot}%{nodejs_sitelib}/promise

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec --timeout 200 --slow 99999
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc Readme.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/promise


%changelog
