Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-websocket-driver
Version:    0.3.3
Release:    alt1_11
Summary:    WebSocket protocol handler with pluggable I/O for Node.js
License:    MIT
URL:        http://github.com/faye/websocket-driver-node
Source0:    http://registry.npmjs.org/websocket-driver/-/websocket-driver-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(jstest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/websocket-driver
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/websocket-driver

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/jstest spec/runner.js
%endif


%files
%doc CHANGELOG.md README.md examples/
%{nodejs_sitelib}/websocket-driver


%changelog
