%define module_name AI-ParticleSwarmOptimization-Pmap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AI/ParticleSwarmOptimization.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Parallel/parallel_map.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.008
Release: alt1
Summary: Particle Swarm Optimization (object oriented) with support for multi-core processing
Group: Development/Perl
License: lgpl
URL: https://github.com/d-strzelec/AI-ParticleSwarmOptimization-Pmap

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STRZELEC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is enhancement of on original AI::ParticleSwarmOptimization to support 
multi-core processing with use of Pmap. Below you can find original documentation
of that module, but with one difference. There is new parameter "-workers", which
one can use to define of number of parallel processes that will be used during 
computations.

The Particle Swarm Optimization technique uses communication of the current best
position found between a number of particles moving over a hyper surface as a
technique for locating the best location on the surface (where 'best' is the
minimum of some fitness function). For a Wikipedia discussion of PSO see
http://en.wikipedia.org/wiki/Particle_swarm_optimization.

This pure Perl module is an implementation of the Particle Swarm Optimization
technique for finding minima of hyper surfaces. It presents an object oriented
interface that facilitates easy configuration of the optimization parameters and
(in principle) allows the creation of derived classes to reimplement all aspects
of the optimization engine (a future version will describe the replaceable
engine components).

This implementation allows communication of a local best point between a
selected number of neighbours. It does not support a single global best position
that is known to all particles in the swarm.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README example
%perl_vendor_privlib/A*

%changelog
