%define module_name Acme-CPANModules-GrepVariants
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.013
Release: alt1
Summary: Grep-like CLI utilities available on CPAN
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-GrepVariants

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Grep-like CLI utilities available on CPAN.

Improvements

Created in 2005 by Andy Lester, the ack manpage is the granddaddy of grep-like programs
that try to improve the experience of using grep to search for text in source
code. ack skips VCS directories like `.git' or `.svn', and understands file
types so it doesn't look into giant `.mp4's and other binaries by default. ack
has spurred the development of other ack improvements (mostly in speed aspect)
like The Silver Searcher (`ag') or `ripgrep'. `git' also now includes a
`git-grep' utility. ack has a website: https://beyondgrep.com. See also
https://betterthanack.com.

the App::Greple manpage and the App::abgrep manpage try to make searching for multiple
patterns in grep easier. To search for all 'foo' and 'bar' in grep in no
particular order, you either have to do something like:

 %% grep --color=always foo FILES | grep bar

or:

 %% grep -P 'foo.*bar|bar.*foo' FILES

both of which get unwieldy if the number of patterns get higher. Or you can use
look-ahead:

 %% grep -P '(?=.*foo)(?=.*bar)' FILES

but this does not capture (thus highlight) the patterns.

Note that searching for multiple patterns in particular order ('foo.*bar'), or
searching for aternates from multiple patterns ('foo|bar') is no problem in
grep.

greple also has a few other tricks up its sleeve, like configuration file to
define complex regexes, matching across lines, and Japanese text support.

Instead of specifying a pattern, with the App::rpgrep manpage you can specify a pattern
name in a the Regexp::Pattern manpage::* module instead.

Reimplementations

grep for the PerlPowerTools manpage simply tries to reimplement grep in Perl, as part
of the project to reimplement many Unix utilities in Perl. It has few practical
uses.

Searching Perl source code

the App::pmgrep manpage lets you grep over locally installed Perl modules. It's
basically a shortcut for something like this:

 %% pmlist -Rx | grep PAT
 %% grep PAT `pmlist -Rx'

the App::Grepl manpage uses the PPI manpage to let you gr...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%changelog
