# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Class/Data/Inheritable.pm) perl(ExtUtils/MakeMaker.pm) perl(Feed/Find.pm) perl(LWP/UserAgent.pm) perl(Module/Pluggable.pm) perl(Test/More.pm) perl(Text/ASCIITable.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Acme-Web20-Validator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Web 2.0 Validation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NA/NAOYA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Acme::Web20::Validator is a Web 2.0 Validation module for your website.
This module is inspired from Web 2.0 Validator (http://web2.0validator.com/).

The definition of web 2.0 changes on a daily basis but currently
supports are:

  UsePrototype
  UseCatalyst
  UseRails
  MentionsWeb20
  UseLighttpd
  HasAnyFeeds
  ReferToDelicious
  XHtmlStrict
  UseCSS
  UseFeedBurner
  HasTrackbackURI

And the Rule is also pluggable with Module::Pluggable, so you can add
any rules by yourself. For example:

  package Acme::Web20::Validator::Rule::MyRule;
  use strict;
  use warnings;
  use base qw (Acme::Web20::Validator::Rule);
  __PACKAGE__->name('Your rule's description');

  sub validate {
      my $self = shift;
      my $res = shift; ## HTTP::Response via LWP
      ...
      $self->is_ok(1) if ...;
  }

  1;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
