%define module_name App-DocKnot
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Capture/Tiny.pm) perl(Date/Parse.pm) perl(Encode.pm) perl(File/BaseDir.pm) perl(File/Copy/Recursive.pm) perl(File/ShareDir.pm) perl(Git/Repository.pm) perl(IO/Compress/Xz.pm) perl(IO/Uncompress/Gunzip.pm) perl(IPC/Run.pm) perl(IPC/System/Simple.pm) perl(Image/Size.pm) perl(JSON/MaybeXS.pm) perl(JSON/PP.pm) perl(Kwalify.pm) perl(List/SomeUtils.pm) perl(Module/Build.pm) perl(Perl6/Slurp.pm) perl(Pod/Thread.pm) perl(Pod/Usage.pm) perl(Template.pm) perl(Text/Balanced.pm) perl(YAML/XS.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 5.00
Release: alt1
Summary: Package documentation generator
Group: Development/Perl
License: mit
URL: https://www.eyrie.org/~eagle/software/docknot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
DocKnot is a system for generating consistent human-readable software package
documentation from metadata files, primarily JSON and files containing
documentation snippets.  It takes as input a directory of metadata and a set
of templates and generates a documentation file from the metadata given the
template name.

The path to the metadata directory for a package is given as an explicit
argument to the App::DocKnot constructor.  All other data (currently templates
and license information) is loaded via File::BaseDir and therefore uses XDG
paths by default.  This means that templates and other global configuration
are found by searching the following paths in order:

=over 4

=item 1.

$HOME/.config/docknot

=item 2.

$XDG_CONFIG_DIRS/docknot (/etc/xdg/docknot by default)

=item 3.

Files included in the package.

=back

As noted above, default templates and license files are included with the
App::DocKnot module and are used unless more specific configuration files
exist.
%prep
%setup -q -n %{module_name}-%{version}

[ %version = 5.00 ] && rm -f t/cli/spin.t t/spin/tree.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes TODO README.md docs
%perl_vendor_privlib/A*
%_man1dir/*
%perl_vendor_privlib/auto/*
%_bindir/*

%changelog
