%define module_name Bing-ContentAPI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(JSON.pm) perl(REST/Client.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Perl interface to the Bing Ads Content API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BG/BGERRARD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Add, modify and delete products from the Bing Merchant Center platform via
  the Bing Ads Content API.

  https://docs.microsoft.com/bingads/shopping-content/

  Authentication is done via OAuth using Authorization Code Grant Flow
  https://docs.microsoft.com/bingads/guides/authentication-oauth

  Steps to authorize a native application and generate an initial refresh token:

  Note: Substitute CLIENT_ID, UNIQUE_CODE and AUTHORIZATION_CODE with the
  actual values in the appropriate locations in the examples.

  1) Request user consent through web browser:
  (using existing Bing Ads Microsoft account when prompted)

  https://login.live.com/oauth20_authorize.srf?client_id=CLIENT_ID&scope=bingads.manage&response_type=code&redirect_uri=https://login.live.com/oauth20_desktop.srf&state=UNIQUE_CODE

  Response received:
  https://login.live.com/oauth20_desktop.srf?code=AUTHORIZATION_CODE&state=UNIQUE_CODE&lc=1033

  2) Use the authorization 'code' received to request the access token and refresh token:

  $ curl \
    -d client_id=CLIENT_ID \
    -d code=AUTHORIZATION_CODE \
    -d grant_type=authorization_code \
    -d redirect_uri=https://login.live.com/oauth20_desktop.srf \
    -H "Content-Type: application/x-www-form-urlencoded" \
    https://login.live.com/oauth20_token.srf

  Response:
  {
    "token_type": "bearer",
    "expires_in": 3600,
    "scope": "bingads.manage",
    "access_token": "...",
    "refresh_token": "...",
    "user_id": "..."
  }

  3) Use the received refresh_token as the initial refresh_token in Bing::ContentAPI->new()

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.pod
%perl_vendor_privlib/B*

%changelog
