%define module_name Bio-DB-NCBIHelper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/Query/WebQuery.pm) perl(Bio/DB/Taxonomy.pm) perl(Bio/DB/WebDBSeqI.pm) perl(Bio/Root/IO.pm) perl(Bio/Root/Root.pm) perl(Bio/SeqIO.pm) perl(Bio/SeqIO/entrezgene.pm) perl(Bio/Taxon.pm) perl(Bio/WebAgent.pm) perl(CGI.pm) perl(Cache/FileCache.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(HTTP/Request/Common.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/Exception.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Pod.pm) perl(Test/RequiresInternet.pm) perl(URI.pm) perl(URI/Escape.pm) perl(XML/Twig.pm) perl(base.pm) perl(constant.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.7
Release: alt1
Summary: A collection of routines useful for queries to NCBI databases.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-NCBIHelper

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides a single place to setup some common methods for querying NCBI
web databases.  This module just centralizes the methods for
constructing a URL for querying NCBI GenBank and NCBI GenPept and the
common HTML stripping done in the postprocess_data manpage().

The base NCBI query URL used is:
https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%if "%version" == "1.7.7"
%define _without_test 1
%endif

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
