# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CPAN-PackageDetails
%define upstream_version 0.264

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Create or read 02packages.details.txt.gz
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/CPAN/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/DistnameInfo.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(IO/Compress/Gzip.pm)
BuildRequires: perl(IO/Uncompress/Gunzip.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Output.pm)
BuildRequires: perl(version.pm)
BuildArch:  noarch
Source44: import.info

%description
An entry is a single line from _02packages.details.txt_ that maps a package
name to a source. It's a whitespace-separated list that has the values for
the column identified in the "columns" field in the header.

By default, there are three columns: package name, version, and path.

Inside a CPAN::PackageDetails object, the actual work and manipulation of
the entries are handled by delegate classes specified in 'entries_class'
and 'entry_class'). At the moment these are immutable, so you'd have to
subclass this module to change them.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  examples
%perl_vendor_privlib/*

%changelog
