%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst.pm) perl(Catalyst/Base.pm) perl(Catalyst/Plugin/Authentication.pm) perl(Catalyst/Plugin/Authentication/Credential/Password.pm) perl(Catalyst/Test.pm) perl(Config.pm) perl(Cwd.pm) perl(Digest/SHA1.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(NEXT.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(XML/Atom.pm) perl(XML/Atom/Client.pm) perl(XML/Atom/Entry.pm) perl(XML/Atom/Feed.pm) perl(XML/Atom/Util.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Catalyst-Plugin-AtomServer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Atom Server implementation for Catalyst applications
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BT/BTROTT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
*Catalyst::Plugin::AtomServer* implements the necessary bits to make it easy
to build an Atom API server for any Catalyst-based application.

It implements:

=over 4

=item * Simple XML Views

*Catalyst::View::Atom::XML* provides a base view class that your application
can subclass can use to provide a simple view. Given an *XML::Atom*-based
class in `$c-<stash->{xml_atom_object}', it will automatically
serialize the object to XML and set the appropriate response headers.

=item * Request Extensions

*Catalyst::Plugin::AtomServer* extends the *Catalyst::Request* object to
add a couple of useful methods:

=over 4

=item * $req->is_atom

Once you know that a particular request is an Atom request, your Catalyst
handler should set *is_atom* to `1', like so:

    $c->request->is_atom(1);

=item * $req->url_parameters

Atom servers often implement parametrized requests in the *path_info*
portion of the request URI. These parameters will be automatically split up
into the *url_parameters* hash reference. For example, the URI

    /base/foo=bar/baz=quux/

would be split into the hash reference

    {
        foo => 'bar',
        baz => 'quux',
    }

=item * $req->body_parsed

A parsed XML document containing the Atom portion of the request (the entire
request content in the case of a REST request, and only the Atom portion of
a SOAP request).

You can pass this in directly to initialize an *XML::Atom*-based object.
For example:

    my $entry = XML::Atom::Entry->new( Doc => $req->body_parsed );

=back

=item * Authentication

*Catalyst::Plugin::Authentication::Credential::Atom* provides support for
Basic and WSSE authentication using an Atom envelope. WSSE is supported
using either SOAP or REST, and Basic is supported in REST only.

=item * REST and SOAP interfaces

The Atom API supports either a REST interface or a SOAP interface using
a document-literal SOAP envelope. *Catalyst::Plugin::AtomServer* supports
both interfaces, transparently for your application.

=item * Error Handling

*Catalyst::Plugin::AtomServer* will automatically catch any exceptions
thrown by your application, and it will wrap the exception in the proper
response expected by an Atom client.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
