# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst/Controller.pm) perl(CatalystX/InjectComponent.pm) perl(DBI/Log.pm) perl(DDP.pm) perl(Data/UUID.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/stat.pm) perl(HTML/Entities.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Catalyst-Plugin-Profile-DBI-Log
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Capture queries executed during a Catalyst route with DBI::Log
Group: Development/Perl
License: perl
URL: https://github.com/bigpresh/Catalyst-Plugin-Profile-DBI-Log

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGPRESH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
I needed a way to quickly and easily see, for each API route invocation (HTTP
request) my app handled,

=over

=item How many DB queries were performed

=item How long we spent waiting for DB queries

=item What the actual queries executed were and how long each took

=item Where in our codebase those queries were performed

=back

This plugin is designed to simplify just that.

When loaded, it arranges for the DBI::Log manpage to log all queries to log files,
while adding some metadata of our own to identify the HTTP request being
processed.  It adds a route handler to provide routes to list requests
profiled along with summary info (how many queries, how long spent waiting on
queries etc), and clickable links to view all the queries performed, and to
view a stack trace of where the query was performed from (to see easily what
part of your codebase triggered it).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
