%define module_version 0.0226
%define module_name Catalyst-View-SVG-TT-Graph
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Action/RenderView.pm) perl(Catalyst/Plugin/ConfigLoader.pm) perl(Catalyst/Plugin/Static/Simple.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/ScriptRunner.pm) perl(Catalyst/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Image/LibRSVG.pm) perl(MIME/Types.pm) perl(Moose.pm) perl(SVG/TT/Graph.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0226
Release: alt1
Summary: SVG::TT::Graph charts (in svg/png/gif/jpeg..) for your Catalyst application
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TE/TERENCEMO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Create your view class:

    ./script/myapp_create.pl view Chart SVG::TT::Graph

Set your chart preferences in your config:

    <View::Chart>
        format         png
        <chart_conf>
            style_sheet         /path/to/stylesheet.css
            show_graph_title    1
        </chart_conf>
    </View::Chart>

Stash your chart data in your controller:

    $c->stash->{chart_title} = 'Sales data'; # optional
    
    $c->stash->{chart_type} = 'Bar'; # or Pie/Line/BarHorizontal
    
    $c->stash->{chart_conf} = {
        height  => 400,
        width   => 600
    };
    
    $c->stash->{chart_fields} = [ qw(Jan Feb March ..) ];
    $c->stash->{chart_data} = [ 120, 102, ..];

In your end method:

    $c->forward($c->view('Chart'));

If you want, say a comparative line graph of mutiple sets of data:

    $c->stash->{chart_type} = 'Line';
    
    $c->stash->{chart_data} = [
        { title => 'Barcelona', data => [ ... ] },
        { title => 'Atletico', data => [ ... ] },
    ];


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
