# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/Mol.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Chemistry-MacroMol
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Perl module for macromolecules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
For the purposes of this module, a macromolecule is just a molecule that 
consists of several "domains". For example, a protein consists of aminoacid
residues, or a nucleic acid consists of bases. Therefore Chemistry::MacroMol 
is derived from Chemistry::Mol, with additional methods to handle the domains.

The way things are currently structured, an atom in a macromolecule "belong"
both to the MacroMol object and to a Domain object. This way you can get all the
atoms in $protein via $protein->atoms, or to the atoms in residue 123 via
$protein->domain(123)->atoms.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
