# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Class-Colon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Makes objects out of colon delimited records and vice versa
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PH/PHILCROW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
To turn your colon delimited file into a list of objects, use `Class::Colon',
giving it the name you want to use for the class and an anonymous array of
column names which will become attributes of the objects in the class.  List
the names in the order they appear in the input.  Missing fields will be set
to "".  Extra fields will be ignored.  Use lower case names for the fields.
Upper case names are reserved for use as methods of the class.

Most fields will be simple scalars, but if one of the fields should be an
object, its entry should be of the form

    attribute_name=package_name=constructor_name

as shown above for `date_of_birth' which is of type `Date' whose constructor
is `new'.  In that example, I could have omitted the constructor name, since
`new' is the default.

You may objectify as many different record types as you like in one use
statement.  You may have multiple use statements throughout your program
or module.  If you are using this package from another package, you should
worry a little about namespace collision.  There is only one list of classes
made by this package.  The names must be unique or Bad Things will happen.
Feel free to include your module name in the names of the fabricated classes
as in:

    package YourModule;
    use Class::Colon YourModule::Person => [ qw( field names here ) ];

You wouldn't have to use the double colon, but it makes sense to me.

If your delimiter is not colon, call DELIM on *your* class *before* calling
`READ_*'.  Pass it as a string.  It can be any length, but is taken
literally.

Feel free to add code to the generated package(s) before or after using
Class::Colon.  But, keep in mind possible name conflicts.  As pointed out
below (under METHODS), all ALL_CAPS names are reserved.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes TODO README
%perl_vendor_privlib/C*

%changelog
