# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Table.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Object/Pad.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name ControlBreak
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Compare values during iteration to detect changes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PU/PUCKERING/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The ControlBreak module provides a class that is used to detect
control breaks; i.e. when a value changes.

Typically, the data being retrieved or iterated over is ordered and
there may be more than one value that is of interest.  For example
consider a table of population data with columns for country,
district and city, sorted by country and district.  With this module
you can create an object that will detect changes in the district or
country, considered level 1 and level 2 respectively. The calling
program can take action, such as printing subtotals, whenever level
changes are detected.

Ordered data is not a requirement.  An example using unordered data
would be counting consecutive numbers within a data stream; e.g. 0 0
1 1 1 1 0 1 1. Using ControlBreak you can detect each change and
count the consecutive values, yielding two zeros, four 1's, one zero,
and two 1's.

Note that ControlBreak cannot detect the end of your data stream.
The test() method is normally called within a loop to detect changes
in control variables, but once the last iteration is processed there
are no further calls to test() as the loop ends.  It may be necessary,
therefore, to do additional processing after the loop in order to
handle the very last data group; e.g. to print a final set of subtotals.

To simplify this situation, method test_and_do()) can be used in
place of test() and continue().


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes CONTRIBUTING README LICENSE
%perl_vendor_privlib/C*

%changelog
