%def_without test
%define module_name Crypt-OpenSSL-CA
# BEGIN SourceDeps(oneline):
BuildRequires: libssl-devel perl(CPAN/Meta.pm) perl(Convert/ASN1.pm) perl(Devel/Leak.pm) perl(Devel/Mallinfo.pm) perl(Exporter.pm) perl(File/Find/Rule/Perl.pm) perl(File/Slurp.pm) perl(File/Spec/Functions.pm) perl(File/Spec/Unix.pm) perl(FindBin.pm) perl(IO/File.pm) perl(IPC/Run.pm) perl(Inline.pm) perl(Inline/C.pm) perl(MIME/Base64.pm) perl(Math/BigInt.pm) perl(Module/Build.pm) perl(Net/SSLeay.pm) perl(Pod/Checker.pm) perl(Test/Dependencies.pm) perl(Test/Kwalitee.pm) perl(Test/NoBreakpoints.pm) perl(Test/Pod/Coverage.pm) perl(Test/Taint.pm) perl(Test2/API.pm) perl(Test2/Tools/Basic.pm) perl(Test2/Tools/Compare.pm) perl(Test2/V0.pm) perl(XSLoader.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.91
Release: alt2
Summary: The crypto parts of an X509v3 Certification Authority
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOMQ/%{module_name}-%{version}.tar.gz

%description
This module performs the cryptographic operations necessary to issue
X509 certificates and certificate revocation lists (CRLs).  It is
implemented as a Perl wrapper around the popular OpenSSL library.

*Crypt::OpenSSL::CA* is an essential building block to create an
X509v3 Certification Authority or CA, a crucial part of an X509
Public Key Infrastructure (PKI). A CA is defined by RFC4210 and
friends (see the Crypt::OpenSSL::CA::Resources manpage) as a piece of software
that can (among other things) issue and revoke X509v3 certificates.
To perform the necessary cryptographic operations, it needs a private
key that is kept secret (currently only RSA is supported).

Despite the name and unlike the `openssl ca' command-line tool,
*Crypt::OpenSSL::CA* is not designed as a full-fledged X509v3
Certification Authority (CA) in and of itself: some key features are
missing, most notably persistence (e.g. to remember issued and revoked
certificates between two CRL issuances) and security-policy based
screening of certificate requests.  *Crypt::OpenSSL::CA* mostly does
``just the crypto'', and this is deliberate: OpenSSL's features such
as configuration file parsing, that are best implemented in Perl, have
been left out for maximum flexibility.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_archlib/auto/*
%perl_vendor_archlib/C*
%changelog
