Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Crypt-RC4-XS
Version:        0.02
Release:        alt13_41
Summary:        Perl implementation of the RC4 encryption algorithm
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Crypt-RC4-XS
Source0:        https://cpan.metacpan.org/authors/id/O/OY/OYAMA/Crypt-RC4-XS-%{version}.tar.gz

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)

# Required for the unit tests
BuildRequires:  perl(Test/More.pm)

# Don't provide private shared objects

Source44: import.info

%description
This module XS implementation of the RC4 algorithm, developed by RSA
Security, Inc. Here is the description from Wikipedia website:

In cryptography, RC4 (also known as ARC4 or ARCFOUR meaning Alleged RC4, see
below) is the most widely-used software stream cipher and is used in popular
protocols such as Secure Sockets Layer (SSL) (to protect Internet traffic)
and WEP (to secure wireless networks). While remarkable for its simplicity
and speed in software, RC4 is vulnerable to attacks when the beginning of the
output keystream is not discarded, or a single keystream is used twice; some
ways of using RC4 can lead to very insecure cryptosystems such as WEP.


%prep
%setup -q -n Crypt-RC4-XS-%{version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}"
%make_build


%install
make pure_install PERL_INSTALL_ROOT=%{buildroot}

find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -type f -name '*.bs' -size 0 -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} %{buildroot}/*


%check
make test


%files
%doc Changes README
%{perl_vendor_archlib}/Crypt
%{perl_vendor_archlib}/auto/Crypt

%changelog
