%define module_name DBIx-ThinSQL-SQLite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(CPAN/Meta.pm) perl(CPAN/Meta/Check.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/ThinSQL.pm) perl(Data/Dumper.pm) perl(Digest/SHA.pm) perl(Exporter/Tidy.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/chdir.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Log/Any/Adapter.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Tiny.pm) perl(Socket.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.17
Release: alt1
Summary: add various functions to SQLite
Group: Development/Perl
License: unknown
URL: https://github.com/mlawren/p5-DBIx-ThinSQL-SQLite

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLAWREN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
DBIx::ThinSQL::SQLite adds various functions to the SQL syntax
understood by SQLite, using the *sqlite_create_function()* and
*sqlite_create_aggregate_function()* methods of the DBD::SQLite manpage. It
also adds sequence methods to the DBIx::ThinSQL manpage database handles.

The following functions are exported on request:

=over

=item create_sqlite_sequence( $dbh )

Ensure that the `sqlite_sequence' table exists.  This function must be
called on the database (once only - the changes are permanent) before
any of the other sequence related functions or methods will work.

This function works by creating (and dropping) a table with an
`INTEGER PRIMARY KEY AUTOINCREMENT' definition. If you are using the
sequence support from this module you probably don't want to be
creating your own tables with the autoincrement feature, as it may
clash with this module.

=item create_functions( $dbh, @functions )

Add `@functions' to the SQL understood by SQLite for the database
handle `$dbh'. `@functions' can be any combination of the following:

=over

=item debug( @items )

This function called from SQL context logs `@items' with a `debug()'
call to a the Log::Any manpage instance.  If the first item of `@items' begins
with `/^select/i' then that statement will be run and the result
logged using `log_debug' from the DBIx::ThinSQL manpage instead.

=item create_sequence( $name )

Create a sequence in the database with name $name.

=item nextval( $name ) -> Int

Advance the sequence to its next value and return that value.

=item currval( $name ) -> Int

Return the current value of the sequence.

=back

If the Digest::SHA manpage is installed then the following functions can also be
created.

=over

=item sha1( $expr, ... ) -> bytes

Calculate the SHA digest of `$expr' and return it in a 20-byte binary
form. Unfortunately it seems that the underlying SQLite C
sqlite_create_function() provides no way to identify the result as a
blob, so you must always manually cast the result in SQL like so:

    CAST(sha1(SQLITE_EXPRESSION) AS blob)

=item sha1_hex( $expr, ... ) -> hexidecimal

Calculate the SQLite digest of `$expr' and return it in a 40-character
hexidecimal form.

=item sha1_base64( $expr, ... ) -> base64

Calculate the SQLite digest of `$expr' and return it in a base64
encoded form.

=item agg_sha1( $expr, $sort_expr ) -> bytes

=item agg_sha1_hex( $expr, $sort_expr ) -> hexidecimal

=item agg_sha1_base64( $expr, $sort_expr ) -> base64

These aggregate functions are for use with statements using GROUP BY.
`$expr' is the expression on which to calculate the SHA1 hash, and
`$sort_expr' determines the (string) comparison order in which
`$expr' is fed to the SHA1 stream.

=back

Note that user-defined SQLite functions are only valid for the current
session.  They must be created each time you connect to the database.
You can have this happen automatically at connect time by taking
advantage of the the DBI manpage `Callbacks' attribute:

    my $db = DBI::ThinSQL->connect(
        $dsn, undef, undef,
        {
            Callbacks => {
                connected => sub {
                    my $dbh = shift;
                    create_functions( $dbh,
                        qw/debug nextval/ );
                  }
            },

        }
    );

=item create_methods( @methods )

Add `@methods' to the DBIx::ThinSQL::db class which can be any
combination of the following:

=over

=item create_sequence( $name )

Create a sequence in the database with name $name.

=item nextval( $name ) -> Int

Advance the sequence to its next value and return that value.

=item currval( $name ) -> Int

Return the current value of the sequence.

=back

These methods are added to a Perl class and are therefore available to
any the DBIx::ThinSQL manpage handle.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes TODO
%perl_vendor_privlib/D*

%changelog
