# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(List/Util.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_name Data-NestedKey
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Object-oriented handling of deeply nested hash structures
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGFOOT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Data::NestedKey provides an object-oriented approach to managing deeply nested 
hash structures using dot-separated keys. This allows structured data to be 
manipulated in a clean and intuitive way without requiring manual traversal 
of nested hashes.

While traditional hash manipulation requires explicitly iterating through nested 
structures, this module allows setting and retrieving values using simple text 
strings. The ability to specify a path using a single, dot-separated key improves 
readability, reduces boilerplate, and enhances efficiency when working with complex 
data structures.

A key motivation for this module is configuration file manipulation. Many applications 
use structured configuration files (e.g., JSON, YAML) where default settings exist, 
but some values require customization. This module enables modifying specific 
configuration elements using intuitive dot-separated keys, making updates more 
straightforward.

For example, given a JSON configuration file, a utility could allow:

   init-config foo.json session_files.dir /some/path

Where the command takes the configuration file name followed by key-value pairs 
representing the specific elements to update. This approach provides a simple 
and effective way to adjust settings without needing to manually traverse the 
configuration structure.

The class also supports serialization in multiple formats, controlled by 
package variables:

=over 4

=item * `$Data::NestedKey::JSON_PRETTY' (default: 1)

Controls whether JSON output is formatted prettily or in a compact form.

=item * `$Data::NestedKey::FORMAT' (default: 'JSON')

Specifies the serialization format. Supported formats:

    - JSON (default)
    - YAML
    - Data::Dumper
    - Storable

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md ChangeLog
%perl_vendor_privlib/D*

%changelog
