%define module_version 0.002007
%define module_name DestructAssign
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002007
Release: alt6
Summary: Destructuring assignment
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CI/CINDY/%{module_name}-%{module_version}.tar.gz

%description
This mod provides destructuring assignment for Perl.
You can capture (by value) or bind (by alias) variables into
part of a potentially large and complex data structure.

I expect it to bring following benefits:

=over 4

=item enhance the performance by avoiding repeatedly digging into complex data structures

Suppose we have data structures like this:

  my $player1 = {
    id => 25,
    hp => 8100,
    armor => {
      body => {
        id => 21,
        name => 'iron suit',
        protect => 10,
        durability => 100,
      },
      hand => {
        id => 29,
        name => 'iron sword',
        attack => 15,
        durability => 100,
      },
    },
  };
  my $player2 = ...;

Instead of

  while( $player1->{hp}>0 && $player2->{hp}>0 ) {
    my $hit1 =
        ($player1->{armor}{hand}{durability} && $player1->{armor}{hand}{attack}) -
        ($player2->{armor}{body}{durability} && $player2->{armor}{body}{protect});
    my $hit2 =
        ($player2->{armor}{hand}{durability} && $player2->{armor}{hand}{attack}) -
        ($player1->{armor}{body}{durability} && $player1->{armor}{body}{protect});
    $hit1 = 1 if( $hit1 <= 0 );
    $hit2 = 1 if( $hit2 <= 0 );

    $player1->{hp} -= $hit2;
    $player2->{hp} -= $hit1;

    --$player1->{armor}{hand}{durability} if( $player1->{armor}{hand}{durability} );
    --$player1->{armor}{body}{durability} if( $player1->{armor}{body}{durability} );
    --$player2->{armor}{hand}{durability} if( $player2->{armor}{hand}{durability} );
    --$player2->{armor}{body}{durability} if( $player2->{armor}{body}{durability} );
  }

We could write

  des_alias [
    {
      hp => my $hp1,
      armor => {
        body => {
          protect => my $protect1,
          durability => my $body_dura1,
        },
        hand => {
          attack => my $attack1,
          durability => my $hand_dura1,
        },
      }
    },
    {
      hp => my $hp2,
      armor => {
        body => {
          protect => my $protect2,
          durability => my $body_dura2,
        },
        hand => {
          attack => my $attack2,
          durability => my $hand_dura2,
        },
      }
    },
  ] = [$player1, $player2];
  
  while( hp1>0 && hp2>0 ) {
    my $hit1 = ($hand_dura1 && $attack1) - ($body_dura2 && $protect2);
    my $hit2 = ($hand_dura2 && $attack2) - ($body_dura1 && $protect1);
    $hit1 = 1 if( $hit1 <= 0 );
    $hit2 = 1 if( $hit2 <= 0 );

    $hp1 -= $hit2;
    $hp2 -= $hit1;

    --$hand_dura1 if( $hand_dura1 );
    --$body_dura1 if( $body_dura1 );
    --$hand_dura2 if( $hand_dura2 );
    --$body_dura2 if( $body_dura2 );
  }

=item enhance the readability by pointing out all the elements you might touch at the begining of each subroutine

It's a good habit to write named parameters instead of access @_ directly
(except you want to modify the caller's arguments).
This mod extend the ability to name parameters in the deep structure.
You can explicitly list all the elements you might touch in the subroutine.

  sub f {
    des [my $x, { id => my $id, amount => my $amount }] = \@_;
    # or use des_alias, if you need to modify the passed parameters.
    des_alias [my $x, { id => my $id, amount => my $amount }] = \@_;
  }

=back

I've tested this mod in Perl 5.8.9, 5.10.1, 5.12.5, 5.14.4, 5.16.3, 5.18.2, 5.20.0 (by perlbrew) on x86_64.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
