%define _without_test 1
%add_findreq_skiplist %perl_vendor_archlib/B/FindAmpersand.pm
%add_findreq_skiplist %perl_vendor_archlib/D*
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(CPAN/Meta/Converter.pm) perl(Config.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Parse/CPAN/Meta.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.33
%define module_name Devel-SawAmpersand
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.33
Release: alt7
Summary: parse reports to www.cpantesters.org from various sources
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AN/ANDK/%module_name-%module_version.tar.gz

%description
This module provides one single function:.
=over

=item $bool = Devel::SawAmpersand::sawampersand()

Returns a true value if the compiled code has the C-level global
variable PL_sawampersand set.

=back

There's a global variable in the perl source, called PL_sawampersand.
It gets set to true in that moment in which the parser sees one of $`,
$', and $&. It never can be set to false again. Trying to set it to
false breaks the handling of the $`, $&, and $' completely.

If the global variable `PL_sawampersand' is set to true, all
subsequent RE operations will be accompanied by massive in-memory
copying, because there is nobody in the perl source who could predict,
when the (necessary) copy for the ampersand family will be needed.
So all subsequent REs are considerable slower than necessary.

There are at least three impacts for developers:

=over 4

=item *

never use $& and friends in a library. Use /p if you have perl 5.10 or later.

=item *

Don't "use English" in a library, because it contains the three bad
fellows. Corollary: if you really want to use English, do it like so:

    use English qw( -no_match_vars ) ;

=item *

before you release a module or program, check
if PL_sawampersand is set by any of the modules you use or require.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_archlib/D*
%perl_vendor_archlib/B*
%perl_vendor_autolib/*

%changelog
