# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-ChangelogFromGit
%define upstream_version 0.017

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Build CHANGES from git commits and tags
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(DateTime.pm)
BuildRequires: perl(DateTime/Infinite.pm)
BuildRequires: perl(Dist/Zilla/File/InMemory.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Git/Repository/Log/Iterator.pm)
BuildRequires: perl(IPC/Cmd.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Autobox.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Software/Release.pm)
BuildRequires: perl(Software/Release/Change.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Text/Wrap.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This Dist::Zilla plugin writes a CHANGES file that contains formatted
commit information from recent git logs.

This plugin has the following configuration variables:

* * max_age

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CHANGES LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
