# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-FileKeywords
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Standard Keywords plugin
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Dist/Zilla/Role/FileFinderUser.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Autobox.pm)
BuildArch:  noarch
Source44: import.info

%description
This plugin is a file_munger. It processes a list of files (by default all
files in the distribution) and replaces all occurrences of known keywords
with their expansions.

It does this is in a manner similar to how Subversion manages keywords. In
particular it looks for keywords in the forms:

  $$KEYWORD$$
  $$KEYWORD: Stuff $$
  $$KEYWORD::    Stuff $$

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CHANGES INSTALL LICENSE META.yml  README
%perl_vendor_privlib/*


%changelog
