# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-ModuleBuild-XSOrPP
%define upstream_version 0.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Add a --pp option to your Build.PL to force an XS-less build
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Plugin/InlineFiles.pm)
BuildRequires: perl(Dist/Zilla/Plugin/ModuleBuild.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Use this plugin instead of the regular 'ModuleBuild' plugin. It generates a
_Build.PL_ which accepts a '--pp' flag to forcible disable XS compilation.
Obviously, this is only useful if your module can work without its XS
component.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
