# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name DoubleBlind
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension for data-obfuscation in double-blind experiments.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IL/ILYAZ/modules/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The intent is to simplify double-blind experiments in a "friendly"
environment, when it is *known* that the experimentator would not try
to *consciously* break the "coding".  (For example, this may work when
one does experiments on oneself, or when the generated "label" can be
hidden from the subject.)  The decoding can be easily done using
a calculator, but (with exception of major computational savants) cannot
be done unconsciously.

Several items are generated; each one has a "secret" id (which is an
integer from user-specified interval), and a "public" label (which is a
decimal fraction).  A caller-supplied callback function is executed with
these data; it is supposed that it would prepare the experimental data,
and would mark it with the label.

In the simplest case, the callback would do all the work itself.  For
example, given files with names f1.txt .. f55.txt, this code
would rename them to files with names similar to g2342.461.txt:

  sub cb($$$) {
    my ($n, $id, $label) = (shift, shift, shift);
    rename "f$id.txt", "g$label.txt" or die;
  }
  print process_shuffled \&cb, 55, 1;

(additionally, it would output the decoding instructions).  In more
complicated cases, the callback might, e.g., output instructions for a
third party to label the experimental data.

As an additional convenience, the items are supplied to the callback in
a randomized order (the call order is the argument $n to the callback above).
(For example, one could apply one of 55 transformations to each of the
files above basing on the number $n.)

It should work for up to 1e4 items.  (For best result, use 0 for the start
index if the number of items is a power of 10; the top item number should
not exceed 999999.)  Since no attempt of speed optimization is done, large
collections of items may require some computational resources.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/ex.pl

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
