# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(ok.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Event-Join
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: join multiple "events" into one
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JR/JROCKWAY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
When writing event-based programs, you often want to wait for a number
of events to occur, and then do something.  This module allows you to
do that without blocking.  It simply acts as a receiver for a number
of events, and then calls a callback when all events have occurred.

Note that although I mainly use this for "real" event-based
programming, the technique is rather versatile.  A config file parser
could be implemented like this:

   my $parsed_doc;
   my $parser_state = Event::Join->new(
       events        => [qw/username password machine_name/],
       on_completion => sub { $parsed_doc = shift },
   );

   while(!$parsed_doc && (my $line = <$fh>)){
       chomp $line;
       my ($k, $v) = split /:/, $line;
       $parser_state->send_event($k, $v);
   }

   say 'Username is '. $parsed_doc->{username};


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/E*

%changelog
