%define module_name Excel-ValueReader-XLSX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Carp.pm) perl(Clone.pm) perl(Data/XLSX/Parser.pm) perl(Date/Calc.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Spreadsheet/ParseXLSX.pm) perl(Test/More.pm) perl(XML/LibXML/Reader.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: extracting values from Excel workbooks in XLSX format, fast
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module reads the contents of an Excel file in XLSX format;
given a worksheet name it returns a bidimensional array of values
in that worksheet.

Unlike the Spreadsheet::ParseXLSX manpage or the Spreadsheet::XLSX manpage, there is no
support for reading formulas, formats or other Excel internal
information; all you get are plain values -- but you get them much
faster !

This front module has two different backends for extracting values :

=over

=item Regex (default)

this backend uses regular expressions to parse the XML content.

=item LibXML

this backend uses the XML::LibXML::Reader manpage to parse the XML content.
It is probably safer but about three times slower than the Regex backend
(but still much faster than the Spreadsheet::ParseXLSX manpage).

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/E*

%changelog
