%define module_name Exception-FFI-ErrorCode
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny.pm) perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(Ref/Util.pm) perl(Sub/Identify.pm) perl(Test2/V0.pm) perl(constant.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Exception class based on integer error codes common in C code
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Exception::FFI::ErrorCode

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A common pattern in C libraries is to return an integer error code to classify an error.
When translating those APIs to Perl you often want to instead throw an exception.  This
class provides an interface for building exception classes that help with that pattern.

For APIs that provide a `strerror' or similar function that converts the error code into
a human readable diagnostic, you can simply attach it.  If not you can provide human
readable diagnostics for each error code using an array reference, as shown above.

The base class for your exception class will be set to
Exception::FFI::ErrorCode::Base.  The base class
handles determining the location of where the exception was thrown and will stringify
in a way to look like a regular Perl string exception with the filename and line number
you would expect.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README author.yml Changes
%perl_vendor_privlib/E*

%changelog
