# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Child.pm) perl(Compress/Raw/Zlib.pm) perl(HTTP/Headers.pm) perl(HTTP/Lite.pm) perl(HTTP/Proxy.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(HTTP/Server/PSGI.pm) perl(LWP/UserAgent.pm) perl(Plack/Loader.pm) perl(Plack/Request.pm) perl(Starlet/Server.pm) perl(Starman.pm) perl(Test/Fake/HTTPD.pm) perl(Test/SharedFork.pm) perl(URI.pm) perl(WWW/Curl/Easy.pm) perl(autodie.pm) perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl(Encode/JP.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Furl
%define upstream_version 3.14

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Response object for Furl
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Accessor/Lite.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(HTTP/Parser/XS.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Mozilla/CA.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Socket.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Requires.pm)
BuildRequires: perl(Test/TCP.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildArch:  noarch
Source44: import.info

%description
Furl is yet another HTTP client library. LWP is the de facto standard HTTP
client for Perl5, but it is too slow for some critical jobs, and too
complex for weekend hacking. Furl resolves these issues. Enjoy it!

This library is an *beta* software. Any API may change without notice.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  TODO example
%{perl_vendor_privlib}/*

%changelog
