# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Date/Calc.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(GD/Graph/hbars.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(Text/CSV/Simple.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 1.2
%define module_name GPS-Tracer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: A processor of geographical route information
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TU/TULSOFT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module reads geographical location data (longitude, latitude and
time) and converts them into various other formats and pre-processed
files that can be used to display route information, for example using
Google Maps.

The module was developed primarily to read data from the secure web
site provided by Guardian Mobility
(http://www.guardianmobility.com) for their product "Tracer" (data
are published there after they are collected from the Globastar
satellites). However, it was made flexible enough that it can also
read data from a simple CSV format instead from their web site.

Some of the files created by this module were designed to be read by
JavaScript in order to create/update web pages. Example of such usage
is on the pages of the Arctic student expedition FrozenFive
(http://frozenfive.org) - for whom the module was actually created
in the first place, and also in the `examples' folder of this module
distribution.

One scenario is to use this module in a periodically and automatically
repeated script (on UNIX machine called a 'cronjob') and let the web
pages read data from output files anytime they are accessed. This is
the way how it was used for the FrozenFive expedition.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README ChangeLog docs
%perl_vendor_privlib/G*

%files scripts
%_bindir/*

%changelog
