Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: /proc
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-GTop
Version:        0.18
Release:        alt14_42
Summary:        Perl interface to libgtop
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/GTop
Source0:        https://cpan.metacpan.org/authors/id/M/MJ/MJH/GTop-%{version}.tar.gz

# core
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(subs.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(warnings.pm)
# non-perl
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libgtop-devel libgtop-gir-devel


Source44: import.info

%description
This is a perl interface to the libgtop library, useful for collecting
real-time performance and other system statistics.


%prep
%setup -q -n GTop-%{version}

# rpmlint pacifications...
find . -type f -exec chmod -c -x {} \;
perl -pi -e 's|^#!perl|#!/usr/bin/perl|' examples/*

# thread funkiness on ppc/s390
%ifarch ppc ppc64 s390
mv t/threads.t t/threads.t.disable
%endif

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README TODO examples/ t/
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/GTop*
%exclude %{perl_vendor_archlib}/config.pl

%changelog
