# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(MooX/ClassAttribute.pm) perl(MooX/StrictConstructor.pm) perl(MooX/Struct.pm) perl(Storable.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Throwable.pm) perl(Try/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.1.3
%define module_name Games-Dukedom
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.3
Release: alt1
Summary: The classic big-iron game
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BOFTX/%{module_name}/Games-Dukedom-v%{module_version}.tar.gz
BuildArch: noarch

%description
This is an implementation of the classic game of "Dukedom". It is intended
to be display agnostic so that it can be used not only by command line
scripts such as the one included but also by graphical UIs such as Tk
or web sites.

It has been implemented as an "interrupt driven" state-machine. The actual
executable application need only concern itself with displaying messages
and collecting appropriate input as requested.

Here is a minimal script that implements a fully functional game:

  
 #!/usr/local/bin/perl
  
 $| = 1;
  
 use strict;
 use warnings;
  
 use Scalar::Util qw( blessed );
 use Try::Tiny;
  
 use Games::Dukedom;
  
 my $input_yn = sub {
    my $default = shift || '';
  
    my $ans = <>;
    chomp($ans);
    $ans ||= $default;
  
    return ( $ans =~ /^(?:q|quit)\s*$/i || $ans =~ /^(?:y|n)$/i )
      ? lc($ans)
      : undef;
 };
  
 my $input_value = sub {
    my $default = shift || 0;
  
    my $ans = <>;
    chomp($ans);
    $ans = $default unless length($ans);
  
    return ( $ans =~ /^(?:q|quit)\s*$/i || $ans !~ /\D/ ) ? $ans : undef;
 };
  
 my %%actions = (
    get_yn    => $input_yn,
    get_value => $input_value,
 );
  
 play_game();
  
 exit;
  
 sub play_game {
    my $game = Games::Dukedom->new;
  
    do {
        try {
            $game->play_one_year;
        }
        catch {
            if ( blessed($_) && $_->isa('Games::Dukedom::Signal') ) {
                print $_->msg if $_->msg;
                return unless defined( $_->action );
  
                my $action = $_->action;
                $game->input( &{ $actions{$action} }( $_->default ) );
            }
            else {
                die $_;
            }
        };
    } until ( $game->game_over );
  
    return;
 }
  
 __END__
  

The important thing to take away from this is how `play_one_year' is wrapped
in a try/catch construct and how the script displays messages and requests
input as needed. This is the heart of the state-machine design.

All of the logic for the game is provided by the module itself...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README Todo LICENSE
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
