%define module_name Graph-Traverse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Graph.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: A traverse() method for the Graph module.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WL/WLINDLEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Graph;
    use Graph::Traverse;

    my $g = Graph->new();
    $g->add_path(qw(A B1 B2 C));
    $g->add_path(qw(A D1 D2 C));

    my $vertices = $g->traverse('A');
    # $vertices now is ['B', 'C', 'D'] or some combination thereof

    my $paths = $g->traverse('A', {hash => 1});
    # $paths contains a hash like this:
    # { 'B1' => { 'vertex' => 'B1',
    #             'path' => ['A', 'B1'],
    #             'weight' => 1 },
    #   'B2' => { 'vertex' => 'B2',
    #             'path' => ['A', 'B1', 'B2'],
    #             'weight' => 2 },
    #   'D1' => { 'vertex' => 'D1',
    #             'path' => ['A', 'D1'],
    #             'weight' => 1 },
    #   'D2' => { 'vertex' => 'D2',
    #             'path' => ['A', 'D1', 'D2'],
    #             'weight' => 2 },
    #   'C' =>  { 'vertex' => 'C',
    #             'path' => ['A', 'D1', 'D2', 'C'],
    #             'weight' => 3 }
    # }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/G*

%changelog
