# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name HATX
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.4
Release: alt1
Summary: A fluent interface for Hash and Array Transformations
Group: Development/Perl
License: perl
URL: https://github.com/hoekit/HATX

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOEKIT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use HATX qw/hatx/;

  # Multiple versions of journal.html and projmgmt.html
  my $files = [
    'journal-v1.0.tar.gz  1201',
    'journal-v1.1.tar.gz  1999',
    'journal-v1.2.tar.gz  3100',
    'projmgmt-v0.1.tar.gz  250',
    'projmgmt-v0.2.tar.gz  350'
  ];

  # Declare a helper object
  my $max = { journal => '0.0', projmgmt => '0.0' };

  # hatx($obj) clones $obj; no clobbering
  my $h = hatx($files)
    # Internal object becomes equivalent to:
    # [ 'journal-v1.0.tar.gz  1201',
    #   'journal-v1.1.tar.gz  1999',
    #   'journal-v1.2.tar.gz  3100',
    #   'projmgmt-v0.1.tar.gz  250',
    #   'projmgmt-v0.2.tar.gz  350' ]

   # Extract components: file, version, bytes
   ->map(sub {
      $_[0] =~ /(journal|projmgmt)-v(.+).tar.gz\s+(\d+)/;
      return [$1, $2, $3];      # e.g. ['journal', '1.0', 1201]
    })
    # Internal object becomes equivalent to:
    # [ ['journal', '1.0', 1201]
    #   ['journal', '1.1', 1999]
    #   ['journal', '1.2', 3100]
    #   ['projmgmt', '0.1', 250]
    #   ['projmgmt', '0.2', 350] ]

  # Accumulate file count and file sizes
  ->apply(sub {
      my ($v, $res) = @_;
      $res->{count}++;
      $res->{bytes} += $v->[2];
    }, my $stats = { count => 0, bytes => 0 })
    # Internal object unchanged
    # The $stats variable becomes { count => 5, bytes => 6900 }

  # Determine the max version of each file, store into $max
  ->apply(sub {
      my ($v, $res) = @_;
      my ($file, $ver, $size) = @$v;
      if ($ver gt $res->{$file}) { $res->{$file} = $ver }
    }, $max)
    # Internal object unchanged
    # $max variable becomes { journal => '1.2', projmgmt => '0.2' }

  # Keep only the max version
  ->grep(sub {
      my ($v, $res) = @_;
      my ($file, $ver, $size) = @$v;
      return $ver eq $res->{$file};
    }, $max)
    # Internal object reduced to:
    # [ ['journal', '1.2', 3100]
    #   ['projmgmt', '0.2', 350] ]
  ;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/H*

%changelog
