%define module_name HTML-Laundry
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(HTML/Parser.pm) perl(HTML/Tidy.pm) perl(HTML/Tidy/libXML.pm) perl(HTML/TreeBuilder.pm) perl(Scalar/Util.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Escape.pm) perl(URI/Split.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0107
Release: alt1
Summary: Perl module to clean HTML by the piece
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HTML::Laundry is an HTML::Parser-based HTML normalizer, 
meant for small pieces of HTML, such as user comments, Atom feed entries,
and the like, rather than full pages. Laundry takes these and returns clean,
sanitary, UTF-8-based XHTML. The parser's behavior may be changed with
callbacks, and the whitelist of acceptable elements and attributes may be
updated on the fly.

A snippet is cleaned several ways:

=over 4

=item * Normalized, using HTML::Parser: attributes and elements will be
lowercased, empty elements such as <img /> and <br /> will be forced into
the empty tag syntax if needed, and unknown attributes and elements will be
stripped.

=item * Sanitized, using an extensible whitelist of valid attributes and 
elements based on Mark Pilgrim and Aaron Swartz's work on `sanitize.py': tags
and attributes which are known to be possible attack vectors are removed.

=item * Tidied, using HTML::Tidy or HTML::Tidy::libXML
(as available): unclosed tags will be closed and the output generally 
neatened; future version may also use tidying to deal with character encoding
issues.

=item * Optionally rebased, to turn relative URLs in attributes into
absolute ones.

=back

HTML::Laundry provides mechanisms to extend the list of known allowed 
(and disallowed) tags, along with callback methods to allow scripts using
HTML::Laundry to extend the behavior in various ways. Future versions
may provide additional options for altering the rules used to clean 
snippets.

Out of the box, HTML::Laundry does not currently know about the <head> tag
and its children. For santizing full HTML pages, consider using HTML::Scrubber
or HTML::Defang.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn Changes
%perl_vendor_privlib/H*

%changelog
