%define module_name HTTP-Request-Generator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Loops.pm) perl(Carp.pm) perl(Dancer/Request.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Filter/signatures.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(Hash/MultiValue.pm) perl(List/MoreUtils.pm) perl(Plack/Request.pm) perl(Pod/Markdown.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: generate HTTP requests
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CORION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use HTTP::Request::Generator 'generate_requests';

    @requests = generate_requests(
        method  => 'GET',
        pattern => 'https://example.com/{bar,foo,gallery}/[00..99].html',
    );

    # generates 300 requests from
    #     https://example.com/bar/00.html to
    #     https://example.com/gallery/99.html

    @requests = generate_requests(
        method => 'POST',
        url    => '/profiles/:name',
        url_params => {
            name => ['Corion','Co-Rion'],
        },
        query_params => {
            stars => [2,3],
        },
        body_params => {
            comment => ['Some comment', 'Another comment, A++'],
        },
        headers => [
            {
                "Content-Type" => 'text/plain; encoding=UTF-8',
                Cookie => 'my_session_id',
            },
            {
                "Content-Type" => 'text/plain; encoding=Latin-1',
                Cookie => 'my_session_id',
            },
        ],
    );
    # Generates 16 requests out of the combinations

    for my $req (@requests) {
        $ua->request( $req );
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn LICENSE README Changes
%perl_vendor_privlib/H*

%changelog
