Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
AutoReq: yes,noperl
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Hardware-Verilog-Parser
Version:        0.13
Release:        alt2_44
Summary:        Complete grammar for parsing Verilog code using perl
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Hardware-Verilog-Parser
Source0:        https://cpan.metacpan.org/authors/id/G/GS/GSLONDON/Hardware-Verilog-Parser-%{version}.tar.gz
Patch0:         Hardware-Verilog-Parser-0.13-grammar.patch
Patch1:         Hardware-Verilog-Parser-0.13-rt51080.patch
Patch2:         Hardware-Verilog-Parser-0.13-Fix-building-on-Perl-without-dot-in-INC.patch
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Benchmark.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Parse/RecDescent.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)

# Filter bogus requires/provides of PrecompiledParser


Source44: import.info
%filter_from_provides /^perl(\(Parse.RecDescent.\)?PrecompiledParser.pm)/d
%filter_from_requires /^perl(PrecompiledParser.pm)/d

%description
This module defines the complete grammar needed to parse any Verilog code.
By overloading this grammar, it is possible to easily create perl scripts
which run through Verilog code and perform specific functions.

%prep
%setup -q -n Hardware-Verilog-Parser-%{version}

# Fix shellbangs
find . -type f | xargs perl -pi -e 's|#! /bin/perl|#! /usr/bin/perl|'

# Fix FTBFS due to typos in grammar (#839599)
%patch0

# Fix "Use of uninitialized value in array dereference" (CPAN RT#51080)
%patch1

#Fix building on Perl without '.' in @INC
%patch2 -p1

%build
./generate_precompiled_parser.pl
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT

%check
# CPAN RT#51080
perl -Iblib/lib ./parser.pl ./test1.v

make test

%files
%doc Changes readme.txt test1.v
%{perl_vendor_privlib}/Hardware/Verilog/

%changelog
